﻿Public Class EditorResources

    Public Shared CompileStarted As Boolean = False

    Public Shared Function CreateSelectionMapEditorBox() As System.Drawing.Bitmap
        Dim Pic_Ac_Memory_GHX As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(New System.Drawing.Bitmap(32, 32))
        Dim Pic_Ac_Memory_BMP As New System.Drawing.Bitmap(32, 32, Pic_Ac_Memory_GHX)
        Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)

        Dim TempPen As New Pen(Preferences.Pref_GridSelectionColor, 4)
        Pic_Ac_Memory_GHX.DrawRectangle(TempPen, New Rectangle(0, 0, 32, 32))

        Return Pic_Ac_Memory_BMP
    End Function

    Public Shared Function CreateSpecialMarker() As System.Drawing.Bitmap
        Dim Pic_Ac_Memory_GHX As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(New System.Drawing.Bitmap(32, 32))
        Dim Pic_Ac_Memory_BMP As New System.Drawing.Bitmap(32, 32, Pic_Ac_Memory_GHX)
        Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)

        Dim TempPen As New Pen(Color.Violet, 4)
        Pic_Ac_Memory_GHX.DrawRectangle(TempPen, New Rectangle(0, 0, 32, 32))
        Pic_Ac_Memory_GHX.DrawString("P", New System.Drawing.Font("Arial", 12, FontStyle.Regular, GraphicsUnit.Pixel), Brushes.Violet, 10, 10)

        Return Pic_Ac_Memory_BMP
    End Function

    Public Shared Function MouseToViewportPos(ByVal MousePos As System.Drawing.Point) As System.Drawing.PointF
        Dim newpos As System.Drawing.PointF
        newpos = Main.Viewport.PointToClient(System.Windows.Forms.Control.MousePosition)
        newpos.X /= 32
        newpos.Y /= 32
        Main.InfoLabel1MousePos.Text = "GridX: " + Math.Round(newpos.X - 0.5).ToString + "  GridY: " + Math.Round(newpos.Y - 0.5).ToString + " | "
        newpos.X = Math.Round(newpos.X - 0.5) * 32
        newpos.Y = Math.Round(newpos.Y - 0.5) * 32
        Main.InfoLabel1MousePos.Text += "X: " + newpos.X.ToString + "->" + (newpos.X + 32).ToString + "  Y: " + newpos.Y.ToString + "->" + (newpos.Y + 32).ToString
        Main.InfoLabel1MousePos.Text += " | UED(X): -" + ((newpos.X / 32) * 256).ToString + ".000000  UED(Y): -" + ((newpos.Y / 32) * 256).ToString + ".000000"
        Return newpos
    End Function

    Public Shared Function DrawGrid(ByVal DrawID As Boolean)
        Dim Pic_Ac_Memory_GHX As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(New System.Drawing.Bitmap(Main.MapWidth * 32, Main.MapHeight * 32))
        Dim Pic_Ac_Memory_BMP As New System.Drawing.Bitmap(Main.MapWidth * 32, Main.MapHeight * 32, Pic_Ac_Memory_GHX)
        Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)
        Dim newpos As System.Drawing.Point
        Dim count As Integer = 0
        Dim count2 As Integer = 0
        Dim ThePen As New Pen(Preferences.Pref_GridForegroundColor, 2)
        While count2 < Main.MapWidth
            newpos.X = count2 * 32
            Pic_Ac_Memory_GHX.DrawLine(ThePen, newpos.X, 0, newpos.X, Main.MapHeight * 32)
            count2 += 1
        End While
        While count < Main.MapHeight
            newpos.Y = count * 32
            Pic_Ac_Memory_GHX.DrawLine(ThePen, 0, newpos.Y, Main.MapWidth * 32, newpos.Y)
            count += 1
        End While
        If DrawID Then
            count = 0
            count2 = 0
            newpos = New System.Drawing.Point(0, 0)
            While count < Main.MapWidth
                While count2 < Main.MapHeight
                    If count > 99 Or count2 > 99 Then
                        Pic_Ac_Memory_GHX.DrawString(count.ToString + ":" + count2.ToString, New System.Drawing.Font("Arial", 6, FontStyle.Regular), Brushes.Blue, count * 32, count2 * 32)
                    Else
                        Pic_Ac_Memory_GHX.DrawString(count.ToString + ":" + count2.ToString, New System.Drawing.Font("Arial", 8, FontStyle.Regular), Brushes.Blue, count * 32, count2 * 32)
                    End If
                    count2 += 1
                End While
                count2 = 0
                count += 1
            End While
        End If
        Return Pic_Ac_Memory_BMP
    End Function

    Public Shared Function CreateGridNRicon() As System.Drawing.Bitmap
        Dim Pic_Ac_Memory_GHX As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(New System.Drawing.Bitmap(32, 32))
        Dim Pic_Ac_Memory_BMP As New System.Drawing.Bitmap(32, 32, Pic_Ac_Memory_GHX)
        Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)

        Pic_Ac_Memory_GHX.DrawString("NR", New System.Drawing.Font("Arial", 15, FontStyle.Regular), Brushes.Blue, 0, 5)

        Return Pic_Ac_Memory_BMP
    End Function

    Public Shared AllActorBitmaps As New List(Of Main.UDM_Image)

    Public Shared Sub DrawOther(ByRef GHX As System.Drawing.Graphics)
        Dim theX As Integer = 0
        Dim theY As Integer = 0

        For Each I As Main.UDM_GRID.UDM_CELL In Main.AllPoints
            If I.Actor = Main.Drawing_Layer Then
                Try
                    theX = I.X
                    theY = I.Y
                Catch Ex As Exception
                    MsgBox("VERY bad map! Sorry but I cannot recover it from here :(", MsgBoxStyle.Critical)
                    Main.AllPoints.Clear()
                    Exit Sub
                End Try
                Try
                    For Each X As Main.UDM_Image In Main.IMG_Representations
                        If I.Tile = X.Name Then
                            'FOUND, now use!
                            GHX.DrawImage(X.Image, theX, theY)
                            Exit For
                            'FIXME, cant this be faster? exit for or even remove this here..
                        End If
                    Next
                Catch Ex As Exception
                    If MsgBox("I don't feel so good :(  That was not very tasty :(" + Chr(13) + "The reason is that something messed up my map parts list" + Chr(13) + "of the current map.. Clean it up?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
                        Main.AllPoints.Clear()
                        Exit For
                    End If
                End Try
            End If
        Next
        '-----------------------------------------------------
        For Each I As Main.UDM_AGRID.UDM_CELL In Main.AllAPoints
            If I.Actor = Main.Drawing_Layer Then
                Try
                    theX = I.X
                    theY = I.Y
                Catch Ex As Exception
                    MsgBox("VERY bad map! Sorry but I cannot recover it from here :(", MsgBoxStyle.Critical)
                    Main.AllAPoints.Clear()
                    Exit Sub
                End Try
                Try
                    For Each X As Main.UDM_Image In AllActorBitmaps
                        If X.Name = I.Tile Then
                            GHX.DrawImage(X.Image, theX + 8, theY + 8, 20, 20)
                            Exit For
                        End If
                    Next
                Catch Ex As Exception
                    If MsgBox("I don't feel so good :(  That was not very tasty :(" + Chr(13) + "The reason is that something messed up my map parts list" + Chr(13) + "of the current map.. Clean it up?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
                        Main.AllAPoints.Clear()
                        Exit For
                    End If
                End Try
            End If
        Next
        '------------------------------------------------
        ' Rectangle selection
        If Main.Mouse_IsDrawing And Main.Drawing_Mode = "rectangle" Then
            If Main.Mouse_SpotOnClick.X - 32 < Main.Mouse_SpotOnMove.X Then
                If Main.Mouse_SpotOnClick.Y < Main.Mouse_SpotOnMove.Y + 32 Then
                    GHX.DrawRectangle(Pens.Yellow, Main.Mouse_SpotOnClick.X, Main.Mouse_SpotOnClick.Y, Main.Mouse_SpotOnMove.X - Main.Mouse_SpotOnClick.X + 32, Main.Mouse_SpotOnMove.Y - Main.Mouse_SpotOnClick.Y + 32)
                Else
                    GHX.DrawRectangle(Pens.Yellow, Main.Mouse_SpotOnClick.X, Main.Mouse_SpotOnMove.Y, Main.Mouse_SpotOnMove.X - Main.Mouse_SpotOnClick.X + 32, Main.Mouse_SpotOnClick.Y - Main.Mouse_SpotOnMove.Y + 32)
                End If
            ElseIf Main.Mouse_SpotOnClick.X + 32 > Main.Mouse_SpotOnMove.X Then
                If Main.Mouse_SpotOnClick.Y > Main.Mouse_SpotOnMove.Y - 32 Then
                    GHX.DrawRectangle(Pens.Yellow, Main.Mouse_SpotOnMove.X, Main.Mouse_SpotOnMove.Y, Main.Mouse_SpotOnClick.X + 32 - Main.Mouse_SpotOnMove.X, Main.Mouse_SpotOnClick.Y + 32 - Main.Mouse_SpotOnMove.Y)
                Else
                    GHX.DrawRectangle(Pens.Yellow, Main.Mouse_SpotOnMove.X, Main.Mouse_SpotOnClick.Y, Main.Mouse_SpotOnClick.X - Main.Mouse_SpotOnMove.X + 32, Main.Mouse_SpotOnMove.Y - Main.Mouse_SpotOnClick.Y + 32)
                End If
            End If
        End If
    End Sub

    'Some functions
    Public Shared Function GetNextLayer(ByVal TheLayer As String) As String
        Dim Awnser As String = ""
        ' We start with the most likely layers, to increase fps if only 3 miliseconds
        If TheLayer = "0" Then
            Awnser = "+1"
        ElseIf TheLayer = "+1" Then
            Awnser = "+2"
        ElseIf TheLayer = "-1" Then
            Awnser = "0"
        ElseIf TheLayer = "+2" Then
            Awnser = "+3"
        ElseIf TheLayer = "-2" Then
            Awnser = "-1"
        ElseIf TheLayer = "+3" Then
            Awnser = "+4"
        ElseIf TheLayer = "-3" Then
            Awnser = "-2"
        ElseIf TheLayer = "+4" Then
            Awnser = "+5"
        ElseIf TheLayer = "-4" Then
            Awnser = "-3"
        ElseIf TheLayer = "+5" Then
            Awnser = "+6"
        ElseIf TheLayer = "-5" Then
            Awnser = "-4"
        ElseIf TheLayer = "+6" Then
            Awnser = "+7"
        ElseIf TheLayer = "-6" Then
            Awnser = "-5"
        ElseIf TheLayer = "+7" Then
            Awnser = "+8"
        ElseIf TheLayer = "-7" Then
            Awnser = "-6"
        ElseIf TheLayer = "+8" Then
            Awnser = "+9"
        ElseIf TheLayer = "-8" Then
            Awnser = "-7"
        ElseIf TheLayer = "+9" Then
            Awnser = "+10"
        ElseIf TheLayer = "-9" Then
            Awnser = "-8"
        ElseIf TheLayer = "+10" Then
            Awnser = "+11"
        ElseIf TheLayer = "-10" Then
            Awnser = "-9"
        ElseIf TheLayer = "+11" Then
            Awnser = "+12"
        ElseIf TheLayer = "-11" Then
            Awnser = "-10"
        ElseIf TheLayer = "+12" Then
            Awnser = "+13"
        ElseIf TheLayer = "-12" Then
            Awnser = "-11"
        ElseIf TheLayer = "+13" Then
            Awnser = "+14"
        ElseIf TheLayer = "-13" Then
            Awnser = "-12"
        ElseIf TheLayer = "+14" Then
            Awnser = "+15"
        ElseIf TheLayer = "-14" Then
            Awnser = "-13"
        ElseIf TheLayer = "+15" Then
            Awnser = "+16"
        ElseIf TheLayer = "-15" Then
            Awnser = "-14"
        ElseIf TheLayer = "+16" Then
            Awnser = "+17"
        ElseIf TheLayer = "-16" Then
            Awnser = "-15"
        ElseIf TheLayer = "+17" Then
            Awnser = "+8"
        ElseIf TheLayer = "-17" Then
            Awnser = "-16"
        ElseIf TheLayer = "+18" Then
            Awnser = "+19"
        ElseIf TheLayer = "-18" Then
            Awnser = "-17"
        ElseIf TheLayer = "+19" Then
            Awnser = "+20"
        ElseIf TheLayer = "-19" Then
            Awnser = "-18"
        ElseIf TheLayer = "+20" Then
            Awnser = "" ' none, default value
        ElseIf TheLayer = "-20" Then
            Awnser = "-19"
        End If
        Return Awnser
    End Function
    Public Shared Function GetPreviousLayer(ByVal TheLayer As String) As String
        Dim Awnser As String = ""
        ' We start with the most likely layers, to increase fps if only 3 miliseconds
        If TheLayer = "0" Then
            Awnser = "-1"
        ElseIf TheLayer = "+1" Then
            Awnser = "0"
        ElseIf TheLayer = "-1" Then
            Awnser = "-2"
        ElseIf TheLayer = "+2" Then
            Awnser = "+1"
        ElseIf TheLayer = "-2" Then
            Awnser = "-3"
        ElseIf TheLayer = "+3" Then
            Awnser = "+2"
        ElseIf TheLayer = "-3" Then
            Awnser = "-4"
        ElseIf TheLayer = "+4" Then
            Awnser = "+3"
        ElseIf TheLayer = "-4" Then
            Awnser = "-5"
        ElseIf TheLayer = "+5" Then
            Awnser = "+4"
        ElseIf TheLayer = "-5" Then
            Awnser = "-6"
        ElseIf TheLayer = "+6" Then
            Awnser = "+5"
        ElseIf TheLayer = "-6" Then
            Awnser = "-7"
        ElseIf TheLayer = "+7" Then
            Awnser = "+6"
        ElseIf TheLayer = "-7" Then
            Awnser = "-8"
        ElseIf TheLayer = "+8" Then
            Awnser = "+7"
        ElseIf TheLayer = "-8" Then
            Awnser = "-9"
        ElseIf TheLayer = "+9" Then
            Awnser = "+8"
        ElseIf TheLayer = "-9" Then
            Awnser = "-10"
        ElseIf TheLayer = "+10" Then
            Awnser = "+9"
        ElseIf TheLayer = "-10" Then
            Awnser = "-11"
        ElseIf TheLayer = "+11" Then
            Awnser = "+10"
        ElseIf TheLayer = "-11" Then
            Awnser = "-12"
        ElseIf TheLayer = "+12" Then
            Awnser = "+11"
        ElseIf TheLayer = "-12" Then
            Awnser = "-13"
        ElseIf TheLayer = "+13" Then
            Awnser = "+12"
        ElseIf TheLayer = "-13" Then
            Awnser = "-14"
        ElseIf TheLayer = "+14" Then
            Awnser = "+13"
        ElseIf TheLayer = "-14" Then
            Awnser = "-15"
        ElseIf TheLayer = "+15" Then
            Awnser = "+14"
        ElseIf TheLayer = "-15" Then
            Awnser = "-16"
        ElseIf TheLayer = "+16" Then
            Awnser = "+15"
        ElseIf TheLayer = "-16" Then
            Awnser = "-17"
        ElseIf TheLayer = "+17" Then
            Awnser = "+16"
        ElseIf TheLayer = "-17" Then
            Awnser = "-18"
        ElseIf TheLayer = "+18" Then
            Awnser = "+17"
        ElseIf TheLayer = "-18" Then
            Awnser = "-19"
        ElseIf TheLayer = "+19" Then
            Awnser = "+18"
        ElseIf TheLayer = "-19" Then
            Awnser = "-20"
        ElseIf TheLayer = "+20" Then
            Awnser = "+19"
        ElseIf TheLayer = "-20" Then
            Awnser = "" ' Nothing, default
        End If
        Return Awnser
    End Function

End Class
